/*
 * %W% %E%
 *
 * Copyright (c) 2000-2004 Sun Microsystems, Inc. All rights reserved.
 * PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms
 */
package example.SoccerQ;

import javax.microedition.lcdui.*;
import javax.microedition.midlet.MIDlet;


/**
 * The alert demo displays a list of alerts that will be displayes once the
 * user clicks a list item. These alerts try to present the full range of
 * alert types supported in MIDP.
 *
 * @version 2.0
 */
public class EventGroupDemo
    extends MIDlet implements CommandListener {

    private static CustomItemDemo resultPanel;// = null;

    private final static Command CMD_EXIT = new Command("Exit", Command.EXIT,
                                                        1);
    private Command               searchCommand = new Command("Search", Command.ITEM, 1);

    private Display display;

    private boolean firsttime;

    private Form mainForm;

    public EventGroupDemo() {
        firsttime = true;
    }

    protected void startApp() {
        if (firsttime) {
            display = Display.getDisplay(this);

            mainForm = new Form("Soccer Video Retrieval - by Event(s)");
            mainForm.append("Please select one or more event(s):");

            // these are the images and strings for the choices.
            Image[] imageArray = null;

            try {

                // load the soccer image to place in the image array
                Image soccer = Image.createImage("/icons/soccer.png");

                // these are the images and strings for the choices.
                imageArray = new Image[] { soccer, soccer, soccer, soccer, soccer, soccer, soccer, soccer, soccer};
            } catch (java.io.IOException err) {
                // ignore the image loading failure the application can recover.
            }

            String[] stringArray = {
                "Goal", "Free Kick", "Corner Kick", "Penalty Kick", "Goal Attempt", "Foul", "Yellow Card", "Red Card", "Player Change"
            };

            // create the list of choice groups.
            ChoiceGroup[] groups = {
//              new ChoiceGroup("Exclusive", ChoiceGroup.EXCLUSIVE, stringArray, imageArray),
                new ChoiceGroup("Multiple", ChoiceGroup.MULTIPLE, stringArray, imageArray),
//              new ChoiceGroup("Pop-Up", ChoiceGroup.POPUP, stringArray, imageArray)
            };

            for (int iter = 0; iter < groups.length; iter++) {
                mainForm.append(groups[iter]);
            }
		mainForm.append(new Gauge("Personalized    ***Results***    Generalized", true, 50, 25));

            mainForm.addCommand(CMD_EXIT);
            mainForm.addCommand(searchCommand);
            mainForm.setCommandListener(this);
            firsttime = false;
        }
        display.setCurrent(mainForm);
    }

    public void commandAction(Command c, Displayable d) {

        if (c == CMD_EXIT) {
            destroyApp(false);
            notifyDestroyed();
        }
        else if (c == searchCommand) {
          //  destroyApp(false);
          //  notifyDestroyed();
        //   resultPanel = new CustomItemDemo();
       //    resultPanel.startApp();

         }
    }

    protected void destroyApp(boolean unconditional) {
    }

    protected void pauseApp() {
    }
}
